"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const js_sdk_common_1 = require("@launchdarkly/js-sdk-common");
const collection_1 = require("./collection");
const Reasons_1 = require("./Reasons");
const variations_1 = require("./variations");
function evalTarget(flag, target, context) {
    const contextKey = context.key(target.contextKind);
    if (contextKey !== undefined) {
        const found = target.values.indexOf(contextKey) >= 0;
        if (found) {
            return (0, variations_1.getVariation)(flag, target.variation, Reasons_1.default.TargetMatch);
        }
    }
    return undefined;
}
/**
 * Evaluate the targets of the specified flag against the given context.
 * @param flag The flag to evaluate targets for.
 * @param context The context to evaluate those targets against.
 * @returns An evaluation result if there is a target match/error or undefined if there is not.
 *
 * @internal
 */
function evalTargets(flag, context) {
    var _a;
    if (!((_a = flag.contextTargets) === null || _a === void 0 ? void 0 : _a.length)) {
        // There are not context targets, so we are going to evaluate the user targets.
        return (0, collection_1.firstResult)(flag.targets, (target) => evalTarget(flag, target, context));
    }
    return (0, collection_1.firstResult)(flag.contextTargets, (target) => {
        if (!target.contextKind || target.contextKind === js_sdk_common_1.Context.UserKind) {
            // When a context target is for a user, then use a user target with the same variation.
            const userTarget = (flag.targets || []).find((ut) => ut.variation === target.variation);
            if (userTarget) {
                return evalTarget(flag, userTarget, context);
            }
            return undefined;
        }
        return evalTarget(flag, target, context);
    });
}
exports.default = evalTargets;
//# sourceMappingURL=evalTargets.js.map