"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A set of static evaluation reasons and methods for creating specific reason instances.
 *
 * @internal
 */
class Reasons {
    static prerequisiteFailed(prerequisiteKey) {
        return { kind: 'PREREQUISITE_FAILED', prerequisiteKey };
    }
    static ruleMatch(ruleId, ruleIndex) {
        return { kind: 'RULE_MATCH', ruleId, ruleIndex };
    }
}
Reasons.Fallthrough = { kind: 'FALLTHROUGH' };
Reasons.Off = { kind: 'OFF' };
Reasons.TargetMatch = { kind: 'TARGET_MATCH' };
exports.default = Reasons;
//# sourceMappingURL=Reasons.js.map