"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPayloadListener = void 0;
const namespaceForKind = (kind) => {
    switch (kind) {
        case 'flag':
            return 'features';
        case 'segment':
            return 'segments';
        default:
            return kind;
    }
};
const createPayloadListener = (dataSourceUpdates, logger, basisReceived = () => { }) => (dataContainer) => {
    const { initMetadata, payload } = dataContainer;
    if (payload.basis) {
        logger === null || logger === void 0 ? void 0 : logger.debug('Initializing all data');
    }
    else if (payload.updates.length > 0) {
        logger === null || logger === void 0 ? void 0 : logger.debug('Applying updates');
    }
    else {
        logger === null || logger === void 0 ? void 0 : logger.debug('Payload had no updates, ignoring.');
        return;
    }
    // convert to LDFeatureStoreDataStorage structure
    const converted = {};
    payload.updates.forEach((it) => {
        const namespace = namespaceForKind(it.kind);
        if (converted[namespace]) {
            // entry for kind already exists, add key
            converted[namespace][it.key] = Object.assign(Object.assign({ version: it.version }, (it.deleted && { deleted: it.deleted })), it.object);
        }
        else {
            // entry for kind doesn't exist, add kind and key
            converted[namespace] = {
                [it.key]: Object.assign(Object.assign({ version: it.version }, (it.deleted && { deleted: it.deleted })), it.object),
            };
        }
        if (it.deleted) {
            logger === null || logger === void 0 ? void 0 : logger.debug(`Deleting ${it.key} in ${it.kind}`);
        }
        else {
            logger === null || logger === void 0 ? void 0 : logger.debug(`Updating ${it.key} in ${it.kind}`);
        }
    });
    // TODO: SDK-1209 - SUpport initMetadata in FDv2 datasources
    dataSourceUpdates.applyChanges(payload.basis, converted, basisReceived, initMetadata, payload.state);
};
exports.createPayloadListener = createPayloadListener;
//# sourceMappingURL=createPayloadListenerFDv2.js.map