"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * A basic wrapper to make async methods with callbacks into promises.
 *
 * @param method
 * @returns A promisified version of the method.
 */
function promisify(method) {
    return new Promise((resolve) => {
        method((val) => {
            resolve(val);
        });
    });
}
exports.default = promisify;
//# sourceMappingURL=promisify.js.map