import { GoogleBaseLLM, } from "@langchain/google-common";
import { GAuthClient } from "./auth.js";
/**
 * Integration with a Google LLM.
 */
export class GoogleLLM extends GoogleBaseLLM {
    // Used for tracing, replace with the same name as your class
    static lc_name() {
        return "GoogleLLM";
    }
    constructor(fields) {
        super(fields);
        Object.defineProperty(this, "lc_serializable", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: true
        });
    }
    buildAbstractedClient(fields) {
        return new GAuthClient(fields);
    }
}
