"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChatGoogle = void 0;
const google_common_1 = require("@langchain/google-common");
const auth_js_1 = require("./auth.cjs");
/**
 * Integration with a Google chat model.
 */
class ChatGoogle extends google_common_1.ChatGoogleBase {
    // Used for tracing, replace with the same name as your class
    static lc_name() {
        return "ChatGoogle";
    }
    constructor(fields) {
        super(fields);
    }
    buildAbstractedClient(fields) {
        return new auth_js_1.GAuthClient(fields);
    }
}
exports.ChatGoogle = ChatGoogle;
