"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureParams = exports.failedAttemptHandler = void 0;
const STATUS_NO_RETRY = [
    400,
    401,
    402,
    403,
    404,
    405,
    406,
    407,
    408,
    409, // Conflict
];
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function failedAttemptHandler(error) {
    const status = error?.response?.status ?? 0;
    if (status === 0) {
        // What is this?
        console.error("failedAttemptHandler", error);
        throw error;
    }
    // What errors shouldn't be retried?
    if (STATUS_NO_RETRY.includes(+status)) {
        throw error;
    }
}
exports.failedAttemptHandler = failedAttemptHandler;
function ensureParams(params) {
    const base = params ?? {};
    return {
        onFailedAttempt: failedAttemptHandler,
        ...base,
    };
}
exports.ensureParams = ensureParams;
