"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requiredOptional = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Make any optional fields required, but add `| undefined` to their type.
 *
 * This bit of logic is to force all fields to be accounted for in conversions
 * from the internal rule schema to the response schema. Rather than use
 * partial, which makes each field optional, we make each field required but
 * possibly undefined. The result is that if a field is forgotten in the
 * conversion from internal schema to response schema TS will report an error.
 * If we just used partial instead, then optional fields can be accidentally
 * omitted from the conversion - and any actual values in those fields
 * internally will be stripped in the response.
 *
 * @example
 * type A = RequiredOptional<{ a?: string; b: number }>;
 * will yield a type of: type A = { a: string | undefined; b: number; }
 *
 * @note
 * We should consider removing this logic altogether from our schemas and use it
 * in place with converters whenever needed.
 */

/**
 * This helper designed to be used with `z.transform` to make all optional fields required.
 *
 * @param schema Zod schema
 * @returns The same schema but with all optional fields required.
 */
const requiredOptional = schema => schema;
exports.requiredOptional = requiredOptional;