"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class BaseAction {
  constructor(props = {}) {
    this.id = (0, _lodash.get)(props, 'id');
    this.type = (0, _lodash.get)(props, 'type');
    this.isNew = (0, _lodash.get)(props, 'isNew', false);
  }
  get upstreamJson() {
    const result = {
      id: this.id,
      type: this.type
    };
    return result;
  }
  get typeName() {
    return this.constructor.typeName;
  }
  get iconClass() {
    return this.constructor.iconClass;
  }
  get selectMessage() {
    return this.constructor.selectMessage;
  }
  get simulateMessage() {
    return _i18n.i18n.translate('xpack.watcher.models.baseAction.simulateMessage', {
      defaultMessage: 'Action {id} simulated successfully',
      values: {
        id: this.id
      }
    });
  }
  get simulatePrompt() {
    return this.constructor.simulatePrompt;
  }
}
exports.BaseAction = BaseAction;
(0, _defineProperty2.default)(BaseAction, "typeName", _i18n.i18n.translate('xpack.watcher.models.baseAction.typeName', {
  defaultMessage: 'Action'
}));
(0, _defineProperty2.default)(BaseAction, "iconClass", 'apps');
(0, _defineProperty2.default)(BaseAction, "selectMessage", _i18n.i18n.translate('xpack.watcher.models.baseAction.selectMessageText', {
  defaultMessage: 'Perform an action.'
}));
(0, _defineProperty2.default)(BaseAction, "simulatePrompt", _i18n.i18n.translate('xpack.watcher.models.baseAction.simulateButtonLabel', {
  defaultMessage: 'Simulate this action now'
}));