"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationsStorage = void 0;
var _contentManagementUtils = require("@kbn/content-management-utils");
var _cm_services = require("./cm_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SO_TYPE = 'visualization';
class VisualizationsStorage extends _contentManagementUtils.SOContentStorage {
  constructor({
    logger,
    throwOnResultValidationError
  }) {
    super({
      savedObjectType: SO_TYPE,
      cmServicesDefinition: _cm_services.cmServicesDefinition,
      enableMSearch: true,
      allowedSavedObjectAttributes: ['title', 'description', 'version', 'visState', 'kibanaSavedObjectMeta', 'uiStateJSON', 'savedSearchRefName'],
      logger,
      throwOnResultValidationError
    });
  }
}
exports.VisualizationsStorage = VisualizationsStorage;