"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showNewVisModal = showNewVisModal;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _services = require("../services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const NewVisModal = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./new_vis_modal'))));
/**
 * shows modal dialog that allows you to create new visualization
 * @param {string[]} editorParams
 * @param {Function} onClose - function that will be called when dialog is closed
 */
function showNewVisModal({
  editorParams = [],
  onClose,
  originatingApp,
  outsideVisualizeApp,
  showAggsSelection,
  selectedVisType
} = {}) {
  const container = document.createElement('div');
  let isClosed = false;

  // initialize variable that will hold reference for unmount
  // eslint-disable-next-line prefer-const
  let unmount;
  const handleClose = () => {
    var _unmount;
    if (isClosed) return;
    onClose === null || onClose === void 0 ? void 0 : onClose();
    (_unmount = unmount) === null || _unmount === void 0 ? void 0 : _unmount();
    isClosed = true;
  };
  const mount = (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(function () {
    return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
        size: "xs",
        position: "fixed"
      }))
    }, /*#__PURE__*/_react.default.createElement(NewVisModal, {
      isOpen: true,
      onClose: handleClose,
      originatingApp: originatingApp,
      stateTransfer: (0, _services.getEmbeddable)().getStateTransfer(),
      outsideVisualizeApp: outsideVisualizeApp,
      editorParams: editorParams,
      visTypesRegistry: (0, _services.getTypes)(),
      contentClient: (0, _services.getContentManagement)().client,
      uiSettings: (0, _services.getUISettings)(),
      addBasePath: (0, _services.getHttp)().basePath.prepend,
      application: (0, _services.getApplication)(),
      docLinks: (0, _services.getDocLinks)(),
      showAggsSelection: showAggsSelection,
      selectedVisType: selectedVisType
    }));
  }), {
    analytics: (0, _services.getAnalytics)(),
    i18n: (0, _services.getI18n)(),
    theme: (0, _services.getTheme)(),
    userProfile: (0, _services.getUserProfile)()
  });
  unmount = mount(container);
  return () => handleClose();
}