"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupSelection = GroupSelection;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _vis_groups_enum = require("../../vis_types/vis_groups_enum");
require("./group_selection.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const tabs = [{
  id: 'recommended',
  label: _i18n.i18n.translate('visualizations.newVisWizard.recommendedTab', {
    defaultMessage: 'Recommended'
  }),
  dataTestSubj: 'groupModalRecommendedTab'
}, {
  id: 'legacy',
  dataTestSubj: 'groupModalLegacyTab',
  label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _i18n.i18n.translate('visualizations.newVisWizard.legacyTab', {
    defaultMessage: 'Legacy'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('visualizations.newVisWizard.legacyTabDescription', {
      defaultMessage: 'Legacy visualizations are scheduled for deprecation in the future.'
    }),
    position: "top"
  })))
}];
const getVisTypesFromGroup = (visTypesRegistry, group) => {
  return visTypesRegistry.getByGroup(group).filter(({
    disableCreate
  }) => !disableCreate);
};
function GroupSelection({
  tab = 'recommended',
  setTab,
  visTypesRegistry,
  ...props
}) {
  const visualizeGuideLink = props.docLinks.links.visualize.guide;
  const promotedVisGroups = (0, _react.useMemo)(() => (0, _lodash.orderBy)([...visTypesRegistry.getAliases(), ...visTypesRegistry.getByGroup(_vis_groups_enum.VisGroups.PROMOTED)].filter(visDefinition => {
    return !visDefinition.disableCreate;
  }), ['promotion', 'title'], ['asc', 'asc']), [visTypesRegistry]);
  const aggBasedTypes = getVisTypesFromGroup(visTypesRegistry, _vis_groups_enum.VisGroups.AGGBASED);
  const legacyTypes = getVisTypesFromGroup(visTypesRegistry, _vis_groups_enum.VisGroups.LEGACY);
  const shouldDisplayLegacyTab = legacyTypes.length + aggBasedTypes.length;
  const [tsvbProps] = legacyTypes.map(visType => ({
    visType: {
      ...visType,
      icon: visType.name === 'metrics' ? 'visualizeApp' : visType.icon
    },
    onVisTypeSelected: props.onVisTypeSelected,
    key: visType.name
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "groupModalHeader",
    id: "vis-wizard-modal-title"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.newVisWizard.title",
    defaultMessage: "Create visualization"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    className: "visNewVisDialogGroupSelection__body"
  }, shouldDisplayLegacyTab && /*#__PURE__*/_react.default.createElement("div", {
    className: "visNewVisDialogGroupSelection__visGroups"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, tabs.map(t => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": t.dataTestSubj,
    isSelected: tab === t.id,
    onClick: () => setTab(t.id),
    key: t.id
  }, t.label)))), /*#__PURE__*/_react.default.createElement("div", {
    className: "visNewVisDialogGroupSelection__visGroups"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), tab === 'recommended' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    "data-test-subj": "visNewDialogGroups"
  }, promotedVisGroups.map(visType => /*#__PURE__*/_react.default.createElement(VisGroup, {
    visType: visType,
    key: visType.name,
    onVisTypeSelected: props.onVisTypeSelected,
    shouldStretch: visType.name === 'lens'
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    "data-test-subj": "visNewDialogGroups"
  }, tsvbProps ? /*#__PURE__*/_react.default.createElement(VisGroup, tsvbProps) : null, /*#__PURE__*/_react.default.createElement(VisGroup, {
    visType: {
      stage: 'production',
      name: 'aggbased',
      description: _i18n.i18n.translate('visualizations.newVisWizard.aggBasedGroupDescription', {
        defaultMessage: 'Craft charts using basic aggregations.'
      }),
      icon: 'indexPatternApp',
      title: _i18n.i18n.translate('visualizations.newVisWizard.aggBasedGroupTitle', {
        defaultMessage: 'Aggregation-based'
      })
    },
    onVisTypeSelected: () => {
      props.showMainDialog(false);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(ModalFooter, {
    visualizeGuideLink: visualizeGuideLink
  })));
}
const ModalFooter = ({
  visualizeGuideLink
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "visNewVisDialogGroupSelection__footer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    className: "visNewVisDialogGroupSelection__footerDescriptionList",
    type: "responsiveColumn",
    compressed: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    className: "visNewVisDialogGroupSelection__footerDescriptionListTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.newVisWizard.learnMoreText",
    defaultMessage: "Want to learn more?"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: visualizeGuideLink,
    target: "_blank",
    external: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visualizations.newVisWizard.viewDocumentationLink",
    defaultMessage: "View documentation"
  })))));
};
const VisGroup = ({
  visType,
  onVisTypeSelected,
  shouldStretch = false
}) => {
  const onClick = (0, _react.useCallback)(() => {
    onVisTypeSelected(visType);
  }, [onVisTypeSelected, visType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "visNewVisDialog__groupsCardWrapper",
    css: shouldStretch ? {
      gridColumn: '1 / -1'
    } : null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    titleSize: "xs",
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "visTypeTitle"
    }, 'titleInWizard' in visType && visType.titleInWizard ? visType.titleInWizard : visType.title),
    onClick: onClick,
    "data-test-subj": `visType-${visType.name}`,
    "data-vis-stage": !('alias' in visType) ? visType.stage : 'alias',
    "aria-label": `visType-${visType.name}`,
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", null, visType.description || ''), /*#__PURE__*/_react.default.createElement("em", null, " ", visType.note || '')),
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: visType.icon || 'empty',
      size: "xl"
    })
  }));
};