"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLinkedSearchUpdates = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useLinkedSearchUpdates = (services, eventEmitter, appState, visInstance) => {
  (0, _react.useEffect)(() => {
    if (appState && visInstance && visInstance.savedSearch && visInstance.vis.data.searchSource) {
      const {
        savedSearch
      } = visInstance;
      // SearchSource is a promise-based stream of search results that can inherit from other search sources.
      const {
        searchSource
      } = visInstance.vis.data;
      const unlinkFromSavedSearch = (showToast = true) => {
        const searchSourceParent = savedSearch.searchSource;
        const searchSourceGrandparent = searchSourceParent === null || searchSourceParent === void 0 ? void 0 : searchSourceParent.getParent();
        const currentIndex = searchSourceParent === null || searchSourceParent === void 0 ? void 0 : searchSourceParent.getField('index');
        visInstance.savedSearch = undefined;
        visInstance.vis.data.savedSearchId = undefined;
        searchSource.setField('index', currentIndex);
        searchSource.setParent(searchSourceGrandparent);
        appState.transitions.unlinkSavedSearch({
          query: searchSourceParent === null || searchSourceParent === void 0 ? void 0 : searchSourceParent.getField('query'),
          parentFilters: (searchSourceParent === null || searchSourceParent === void 0 ? void 0 : searchSourceParent.getOwnField('filter')) || []
        });
        if (showToast) {
          services.toastNotifications.addSuccess(_i18n.i18n.translate('visualizations.linkedToSearch.unlinkSuccessNotificationText', {
            defaultMessage: `Unlinked from Discover session ''{searchTitle}''`,
            values: {
              searchTitle: savedSearch.title
            }
          }));
        }
      };
      eventEmitter.on('unlinkFromSavedSearch', unlinkFromSavedSearch);
      return () => {
        eventEmitter.off('unlinkFromSavedSearch', unlinkFromSavedSearch);
      };
    }
  }, [appState, eventEmitter, visInstance, services.toastNotifications]);
};
exports.useLinkedSearchUpdates = useLinkedSearchUpdates;