"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataViewUpdates = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const updateDataView = (services, visInstance, dataView) => {
  var _visInstance$vis$data;
  const initialSerializedVis = visInstance.vis.serialize();
  visInstance.vis.data.indexPattern = dataView;
  (_visInstance$vis$data = visInstance.vis.data.searchSource) === null || _visInstance$vis$data === void 0 ? void 0 : _visInstance$vis$data.setField('index', dataView);
  visInstance.vis.data.aggs = services.data.search.aggs.createAggConfigs(dataView, initialSerializedVis.data.aggs);
  visInstance.vis.data.savedSearchId = undefined;
};
const useDataViewUpdates = (services, eventEmitter, appState, visInstance) => {
  (0, _react.useEffect)(() => {
    let stateUpdatesSubscription;
    if (appState && visInstance) {
      const syncDataView = async ({
        dataView
      }) => {
        if (dataView && visInstance.vis.data.indexPattern && dataView !== visInstance.vis.data.indexPattern.id) {
          const selectedDataView = await services.dataViews.get(dataView);
          if (selectedDataView) {
            updateDataView(services, visInstance, selectedDataView);
            visInstance.embeddableHandler.reload();
            eventEmitter.emit('updateEditor');
          }
        }
      };
      syncDataView(appState.getState());
      stateUpdatesSubscription = appState.state$.subscribe(syncDataView);
    }
    return () => {
      var _stateUpdatesSubscrip;
      (_stateUpdatesSubscrip = stateUpdatesSubscription) === null || _stateUpdatesSubscrip === void 0 ? void 0 : _stateUpdatesSubscrip.unsubscribe();
    };
  }, [appState, eventEmitter, services, visInstance]);
};
exports.useDataViewUpdates = useDataViewUpdates;