"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findObjectByTitle = findObjectByTitle;
var _content_management = require("../../content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** Returns an object matching a given title */
async function findObjectByTitle(title) {
  if (!title) {
    return;
  }

  // Elastic search will return the most relevant results first, which means exact matches should come
  // first, and so we shouldn't need to request everything. Using 10 just to be on the safe side.
  const response = await _content_management.visualizationsClient.search({
    limit: 10,
    text: `"${title}"`
  }, {
    searchFields: ['title']
  });
  return response.hits.find(obj => obj.attributes.title.toLowerCase() === title.toLowerCase());
}