"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.omitGenericEmbeddableInput = exports.genericEmbeddableInputIsEqual = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// list out the keys from the EmbeddableInput type to allow lodash to pick them later
const allGenericInputKeys = ['lastReloadRequestTime', 'executionContext', 'searchSessionId', 'hidePanelTitles', 'disabledActions', 'disableTriggers', 'enhancements', 'syncColors', 'syncCursor', 'syncTooltips', 'viewMode', 'title', 'id'];
const genericInputKeysToCompare = ['hidePanelTitles', 'disabledActions', 'disableTriggers', 'enhancements', 'syncColors', 'syncCursor', 'syncTooltips', 'title', 'id'];

// type used to ensure that only keys present in EmbeddableInput are extracted

const omitGenericEmbeddableInput = input => (0, _lodash.omit)(input, allGenericInputKeys);
exports.omitGenericEmbeddableInput = omitGenericEmbeddableInput;
const genericEmbeddableInputIsEqual = (currentInput, lastInput) => {
  const {
    title: currentTitle,
    hidePanelTitles: currentHidePanelTitles,
    enhancements: currentEnhancements,
    ...current
  } = (0, _lodash.pick)(currentInput, genericInputKeysToCompare);
  const {
    title: lastTitle,
    hidePanelTitles: lastHidePanelTitles,
    enhancements: lastEnhancements,
    ...last
  } = (0, _lodash.pick)(lastInput, genericInputKeysToCompare);
  if (currentTitle !== lastTitle) return false;
  if (Boolean(currentHidePanelTitles) !== Boolean(lastHidePanelTitles)) return false;
  if (!(0, _fastDeepEqual.default)(currentEnhancements !== null && currentEnhancements !== void 0 ? currentEnhancements : {}, lastEnhancements !== null && lastEnhancements !== void 0 ? lastEnhancements : {})) return false;
  if (!(0, _fastDeepEqual.default)(current, last)) return false;
  return true;
};
exports.genericEmbeddableInputIsEqual = genericEmbeddableInputIsEqual;