"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpressionAst = void 0;
var _public = require("@kbn/expressions-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Creates an ast expression for a visualization based on kibana context (query, filters, timerange)
 * including a saved search if the visualization is based on it.
 * The expression also includes particular visualization expression ast if presented.
 *
 * @internal
 */
const toExpressionAst = async (vis, params) => {
  var _vis$data$searchSourc, _searchSourceExpressi;
  if (!vis.type.toExpressionAst) {
    throw new Error('Visualization type definition should have toExpressionAst function defined');
  }
  const searchSource = (_vis$data$searchSourc = vis.data.searchSource) === null || _vis$data$searchSourc === void 0 ? void 0 : _vis$data$searchSourc.createCopy();
  if (vis.data.aggs) {
    const aggs = vis.data.aggs.clone({
      opts: {
        hierarchical: vis.isHierarchical(),
        partialRows: typeof vis.type.hasPartialRows === 'function' ? vis.type.hasPartialRows(vis) : vis.type.hasPartialRows
      }
    });
    searchSource === null || searchSource === void 0 ? void 0 : searchSource.setField('aggs', aggs);
  }
  const visExpressionAst = await vis.type.toExpressionAst(vis, params);
  const searchSourceExpressionAst = searchSource === null || searchSource === void 0 ? void 0 : searchSource.toExpressionAst({
    asDatatable: vis.type.fetchDatatable
  });
  const expression = {
    ...visExpressionAst,
    chain: [(0, _public.buildExpressionFunction)('kibana', {}).toAst(), ...((_searchSourceExpressi = searchSourceExpressionAst === null || searchSourceExpressionAst === void 0 ? void 0 : searchSourceExpressionAst.chain) !== null && _searchSourceExpressi !== void 0 ? _searchSourceExpressi : []), ...visExpressionAst.chain]
  };
  return expression;
};
exports.toExpressionAst = toExpressionAst;