"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapVisToChartType = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const lensTypesToChartTypes = {
  [_types.LensVisualizationType.XY]: _types.ChartType.XY,
  [_types.LensVisualizationType.Metric]: _types.ChartType.Metric,
  [_types.LensVisualizationType.LegacyMetric]: _types.ChartType.Metric,
  [_types.LensVisualizationType.Pie]: _types.ChartType.Pie,
  [_types.LensVisualizationType.Heatmap]: _types.ChartType.Heatmap,
  [_types.LensVisualizationType.Gauge]: _types.ChartType.Gauge,
  [_types.LensVisualizationType.Datatable]: _types.ChartType.Table,
  [_types.LensVisualizationType.Tagcloud]: _types.ChartType.Tagcloud
};
function isLensVisualizationType(value) {
  return Object.values(_types.LensVisualizationType).includes(value);
}
const mapVisToChartType = visualizationType => {
  if (isLensVisualizationType(visualizationType)) {
    return lensTypesToChartTypes[visualizationType];
  }
};
exports.mapVisToChartType = mapVisToChartType;