"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildPointSeriesData = void 0;
var _get_series = require("./_get_series");
var _get_aspects = require("./_get_aspects");
var _init_y_axis = require("./_init_y_axis");
var _init_x_axis = require("./_init_x_axis");
var _ordered_date_axis = require("./_ordered_date_axis");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const buildPointSeriesData = (table, dimensions) => {
  const chart = {
    aspects: (0, _get_aspects.getAspects)(table, dimensions)
  };
  (0, _init_x_axis.initXAxis)(chart, table);
  (0, _init_y_axis.initYAxis)(chart);
  if ('date' in chart.aspects.x[0].params) {
    // initXAxis will turn `chart` into an `OrderedChart if it is a date axis`
    (0, _ordered_date_axis.orderedDateAxis)(chart);
  }
  chart.series = (0, _get_series.getSeries)(table, chart);

  // @ts-expect-error
  delete chart.aspects;
  return chart;
};
exports.buildPointSeriesData = buildPointSeriesData;