"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.labels = labels;
var _lodash = _interopRequireDefault(require("lodash"));
var _data_array = require("./data_array");
var _uniq_labels = require("./uniq_labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/*
 * Accepts a Kibana data object and returns an array of unique labels (strings).
 * Extracts the field formatter from the raw object and passes it to the
 * getArrOfUniqLabels function.
 *
 * Currently, this service is only used for vertical bar charts and line charts.
 */
function labels(obj) {
  if (!_lodash.default.isObject(obj)) {
    throw new TypeError('LabelUtil expects an object');
  }
  return (0, _uniq_labels.uniqLabels)((0, _data_array.dataArray)(obj));
}