"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataArray = dataArray;
var _lodash = _interopRequireDefault(require("lodash"));
var _flatten_series = require("./flatten_series");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/*
 * Accepts a Kibana data object and returns an array of values objects.
 */
function dataArray(obj) {
  if (!_lodash.default.isObject(obj) || !obj.rows && !obj.columns && !obj.series) {
    throw new TypeError('GetArrayUtilService expects an object with a series, rows, or columns key');
  }
  if (!obj.series) return (0, _flatten_series.flattenSeries)(obj);
  return obj.series;
}