"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createVegaFn = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const createVegaFn = dependencies => ({
  name: 'vega',
  type: 'render',
  inputTypes: ['kibana_context', 'null'],
  help: _i18n.i18n.translate('visTypeVega.function.help', {
    defaultMessage: 'Vega visualization'
  }),
  args: {
    spec: {
      types: ['string'],
      default: '',
      help: ''
    }
  },
  async fn(input, args, context) {
    const {
      createVegaRequestHandler
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
    const vegaRequestHandler = createVegaRequestHandler(dependencies, context);
    const response = await vegaRequestHandler({
      timeRange: (0, _lodash.get)(input, 'timeRange'),
      query: (0, _lodash.get)(input, 'query'),
      filters: (0, _lodash.get)(input, 'filters'),
      visParams: {
        spec: args.spec
      },
      searchSessionId: context.getSearchSessionId(),
      executionContext: context.getExecutionContext()
    });
    return {
      type: 'render',
      as: 'vega_vis',
      value: {
        visData: response,
        visType: 'vega',
        visConfig: {
          spec: args.spec
        }
      }
    };
  }
});
exports.createVegaFn = createVegaFn;