"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withReplacedIds = exports.metricsVisDefinition = void 0;
var _i18n = require("@kbn/i18n");
var _uuid = require("uuid");
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/inspector-plugin/public");
var _editor_controller = require("./application/editor_controller");
var _enums = require("../common/enums");
var _index_patterns_utils = require("../common/index_patterns_utils");
var _constants = require("../common/constants");
var _to_ast = require("./to_ast");
var _services = require("./services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const withReplacedIds = vis => {
  var _vis$params$series;
  const doReplace = obj => {
    if (typeof (obj === null || obj === void 0 ? void 0 : obj.id) === 'function') {
      obj.id = obj.id();
    }
  };
  doReplace(vis.params);
  (_vis$params$series = vis.params.series) === null || _vis$params$series === void 0 ? void 0 : _vis$params$series.forEach(series => {
    var _series$metrics;
    doReplace(series);
    (_series$metrics = series.metrics) === null || _series$metrics === void 0 ? void 0 : _series$metrics.forEach(metric => doReplace(metric));
  });
  return vis;
};
exports.withReplacedIds = withReplacedIds;
async function withDefaultIndexPattern(vis) {
  const dataViews = (0, _services.getDataViewsStart)();
  const defaultIndex = await dataViews.getDefault();
  if (!defaultIndex || !defaultIndex.id || vis.params.index_pattern) return vis;
  vis.params.index_pattern = {
    id: defaultIndex.id
  };
  return vis;
}
async function resolveIndexPattern(indexPatternValue, indexPatterns) {
  if (!indexPatternValue) return;
  if ((0, _index_patterns_utils.isStringTypeIndexPattern)(indexPatternValue)) {
    return await indexPatterns.find(indexPatternValue, 1);
  }
  if (indexPatternValue.id) {
    return [await indexPatterns.get(indexPatternValue.id)];
  }
}
async function getUsedIndexPatterns(params) {
  const dataViews = (0, _services.getDataViewsStart)();
  const defaultIndex = await dataViews.getDefault();
  const resolvedIndexPatterns = [];
  const indexPatternValues = (0, _index_patterns_utils.extractIndexPatternValues)(params, defaultIndex === null || defaultIndex === void 0 ? void 0 : defaultIndex.id);
  (await Promise.all(indexPatternValues.map(indexPatternValue => resolveIndexPattern(indexPatternValue, dataViews)))).forEach(patterns => patterns && resolvedIndexPatterns.push(...patterns));
  return resolvedIndexPatterns;
}
const metricsVisDefinition = exports.metricsVisDefinition = {
  name: _constants.VIS_TYPE,
  title: _i18n.i18n.translate('visTypeTimeseries.kbnVisTypes.metricsTitle', {
    defaultMessage: 'TSVB'
  }),
  description: _i18n.i18n.translate('visTypeTimeseries.kbnVisTypes.metricsDescription', {
    defaultMessage: 'Create visualizations using time series data.'
  }),
  icon: 'visVisualBuilder',
  group: _public.VisGroups.LEGACY,
  order: 10,
  visConfig: {
    defaults: {
      id: () => (0, _uuid.v4)(),
      type: _enums.PANEL_TYPES.TIMESERIES,
      series: [{
        id: () => (0, _uuid.v4)(),
        color: _constants.TSVB_DEFAULT_COLOR,
        split_mode: 'everything',
        palette: {
          type: 'palette',
          name: 'default'
        },
        metrics: [{
          id: () => (0, _uuid.v4)(),
          type: 'count'
        }],
        separate_axis: 0,
        axis_position: 'right',
        formatter: 'default',
        chart_type: 'line',
        line_width: 1,
        point_size: 1,
        fill: 0.5,
        stacked: 'none',
        override_index_pattern: 0,
        series_drop_last_bucket: 0
      }],
      time_field: '',
      index_pattern: '',
      use_kibana_indexes: true,
      interval: '',
      axis_position: 'left',
      axis_formatter: 'number',
      axis_scale: 'normal',
      show_legend: 1,
      truncate_legend: 1,
      max_lines_legend: 1,
      show_grid: 1,
      tooltip_mode: _enums.TOOLTIP_MODES.SHOW_ALL,
      drop_last_bucket: 0
    }
  },
  setup: vis => withDefaultIndexPattern(withReplacedIds(vis)),
  editorConfig: {
    editor: _editor_controller.TSVB_EDITOR_NAME
  },
  options: {
    showFilterBar: true,
    showIndexSelection: false
  },
  toExpressionAst: _to_ast.toExpressionAst,
  getSupportedTriggers: params => {
    if ((params === null || params === void 0 ? void 0 : params.type) === _enums.PANEL_TYPES.TIMESERIES) {
      return [_public.VIS_EVENT_TO_TRIGGER.filter, _public.VIS_EVENT_TO_TRIGGER.brush];
    }
    return [];
  },
  getExpressionVariables: async (vis, timeFilter) => {
    const {
      convertTSVBtoLensConfiguration
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./convert_to_lens')));
    return {
      canNavigateToLens: Boolean(vis !== null && vis !== void 0 && vis.params ? await convertTSVBtoLensConfiguration(vis, timeFilter === null || timeFilter === void 0 ? void 0 : timeFilter.getAbsoluteTime()) : null)
    };
  },
  navigateToLens: async (vis, timeFilter) => {
    const {
      convertTSVBtoLensConfiguration
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./convert_to_lens')));
    return vis !== null && vis !== void 0 && vis.params ? await convertTSVBtoLensConfiguration(vis, timeFilter === null || timeFilter === void 0 ? void 0 : timeFilter.getAbsoluteTime()) : null;
  },
  inspectorAdapters: () => ({
    requests: new _public2.RequestAdapter()
  }),
  requiresSearch: true,
  getUsedIndexPattern: getUsedIndexPatterns
};