"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBarStyles = exports.getAreaStyles = void 0;
var _charts = require("@elastic/charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_COLOR = '#000';
const getAreaStyles = ({
  points,
  lines,
  color
}) => ({
  areaSeriesStyle: {
    line: {
      stroke: color,
      strokeWidth: Number(lines.lineWidth) || 0,
      visible: Boolean(lines.show && lines.lineWidth)
    },
    area: {
      fill: color,
      opacity: lines.fill <= 0 ? 0 : lines.fill,
      visible: Boolean(lines.show)
    },
    point: {
      radius: points.radius || 0.5,
      stroke: color || DEFAULT_COLOR,
      strokeWidth: points.lineWidth || 5,
      visible: points.lineWidth > 0 && Boolean(points.show) ? 'always' : 'never'
    }
  },
  curve: lines.steps ? _charts.CurveType.CURVE_STEP_AFTER : _charts.CurveType.LINEAR
});
exports.getAreaStyles = getAreaStyles;
const getBarStyles = ({
  show = true,
  lineWidth = 0,
  fill = 1
}, color) => ({
  barSeriesStyle: {
    rectBorder: {
      stroke: color || DEFAULT_COLOR,
      strokeWidth: lineWidth,
      visible: show
    },
    rect: {
      fill: color || DEFAULT_COLOR,
      opacity: fill
    }
  }
});
exports.getBarStyles = getBarStyles;