"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.seriesChangeHandler = void 0;
var _new_metric_agg_fn = require("./new_metric_agg_fn");
var _agg_utils = require("../../../../common/agg_utils");
var _collection_actions = require("./collection_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const seriesChangeHandler = (props, items) => doc => {
  // If we only have one sibling and the user changes to a pipeline
  // agg we are going to add the pipeline instead of changing the
  // current item.
  if (items.length === 1 && !(0, _agg_utils.isBasicAgg)(doc)) {
    _collection_actions.handleAdd.call(null, props, () => {
      const metric = (0, _new_metric_agg_fn.newMetricAggFn)();
      metric.type = doc.type;
      if (!['calculation', 'series_agg'].includes(doc.type)) {
        metric.field = doc.id;
      }
      return metric;
    });
  } else {
    _collection_actions.handleChange.call(null, props, doc);
  }
};
exports.seriesChangeHandler = seriesChangeHandler;