"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorComponent = ErrorComponent;
var _eui = require("@elastic/eui");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const guidPattern = /\[[[a-f\d-\\]{36}\]/g;
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _react.useMemo)(() => {
    return {
      sectionSpacingStyle: (0, _react2.css)({
        marginTop: euiTheme.size.s
      }),
      stackStyle: (0, _react2.css)({
        padding: euiTheme.size.s,
        background: euiTheme.colors.lightestShade,
        color: euiTheme.colors.text,
        lineHeight: euiTheme.font.lineHeightMultiplier,
        fontFamily: euiTheme.font.familyCode,
        fontWeight: euiTheme.font.weight.regular,
        whiteSpace: 'pre-wrap'
      })
    };
  }, [euiTheme]);
  return styles;
};
function ErrorComponent(props) {
  const {
    error
  } = props;
  let additionalInfo;
  const type = _lodash.default.get(error, 'error.caused_by.type') || _lodash.default.get(error, 'error.type');
  let reason = _lodash.default.get(error, 'error.caused_by.reason');
  const title = _lodash.default.get(error, 'error.caused_by.title');
  const styles = useStyles();
  if (!reason) {
    reason = _lodash.default.get(error, 'message');
  }
  if (['runtime_exception', 'illegal_argument_exception'].includes(type)) {
    reason = _lodash.default.get(error, 'error.reason').replace(guidPattern, ``);
  }
  if (type === 'script_exception') {
    const scriptStack = _lodash.default.get(error, 'error.caused_by.script_stack');
    reason = _lodash.default.get(error, 'error.caused_by.caused_by.reason');
    additionalInfo = /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbError__additional",
      css: styles.sectionSpacingStyle
    }, /*#__PURE__*/_react.default.createElement("div", null, reason), /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbError__stack",
      css: [styles.sectionSpacingStyle, styles.stackStyle]
    }, scriptStack.join('\n')));
  } else if (reason) {
    additionalInfo = /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbError__additional",
      css: styles.sectionSpacingStyle
    }, reason);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "visError"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    size: "m",
    color: "danger",
    "aria-hidden": "true"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), title || /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.error.requestForPanelFailedErrorMessage",
    defaultMessage: "The request for this panel failed"
  }), additionalInfo));
}
ErrorComponent.propTypes = {
  error: _propTypes.default.object
};