"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSeriesBodyStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const seriesBodyStyles = ({
  euiTheme
}) => (0, _react.css)({
  marginLeft: euiTheme.size.xl,
  marginTop: euiTheme.size.s
});
const useSeriesBodyStyles = () => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const styles = (0, _react2.useMemo)(() => {
    return seriesBodyStyles(euiThemeContext);
  }, [euiThemeContext]);
  return styles;
};
exports.useSeriesBodyStyles = useSeriesBodyStyles;