"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AreaSeriesComponent = void 0;
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// @ts-ignore

const isShowLines = (lines, points) => lines !== null && lines !== void 0 && lines.show ? true : points !== null && points !== void 0 && points.show ? false : true;
const getPointFillColor = (points, color) => {
  var _points$fill;
  const pointFillColor = points !== null && points !== void 0 && points.fillColor || (points === null || points === void 0 ? void 0 : points.fill) === undefined ? 'white' : color;
  return pointFillColor && (0, _chromaJs.default)(pointFillColor).alpha((_points$fill = points === null || points === void 0 ? void 0 : points.fill) !== null && _points$fill !== void 0 ? _points$fill : 1).css();
};
const getAreaSeriesStyle = ({
  color,
  lines,
  points
}) => {
  var _lines$fill, _ref, _lines$show, _points$radius, _points$lineWidth;
  return {
    line: {
      opacity: isShowLines(lines, points) ? 1 : 0,
      stroke: color,
      strokeWidth: (lines === null || lines === void 0 ? void 0 : lines.lineWidth) !== undefined ? Number(lines.lineWidth) : 3,
      visible: isShowLines(lines, points)
    },
    area: {
      fill: color,
      opacity: (_lines$fill = lines === null || lines === void 0 ? void 0 : lines.fill) !== null && _lines$fill !== void 0 ? _lines$fill : 0,
      visible: (_ref = (_lines$show = lines === null || lines === void 0 ? void 0 : lines.show) !== null && _lines$show !== void 0 ? _lines$show : points === null || points === void 0 ? void 0 : points.show) !== null && _ref !== void 0 ? _ref : true
    },
    point: {
      fill: getPointFillColor(points, color),
      opacity: 1,
      radius: (_points$radius = points === null || points === void 0 ? void 0 : points.radius) !== null && _points$radius !== void 0 ? _points$radius : 3,
      stroke: color,
      strokeWidth: (_points$lineWidth = points === null || points === void 0 ? void 0 : points.lineWidth) !== null && _points$lineWidth !== void 0 ? _points$lineWidth : 2,
      visible: points !== null && points !== void 0 && points.show ? 'always' : 'never',
      shape: (points === null || points === void 0 ? void 0 : points.symbol) === 'cross' ? _charts.PointShape.X : points === null || points === void 0 ? void 0 : points.symbol
    }
  };
};
const AreaSeriesComponent = ({
  index,
  groupId,
  visData
}) => {
  var _visData$lines;
  return /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: index + visData.label,
    groupId: groupId,
    name: visData.label
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 0,
    yAccessors: [1],
    data: visData._hide ? [] : visData.data,
    color: visData.color,
    curve: (_visData$lines = visData.lines) !== null && _visData$lines !== void 0 && _visData$lines.steps ? _charts.CurveType.CURVE_STEP : _charts.CurveType.LINEAR,
    stackAccessors: visData.stack ? [0] : undefined,
    areaSeriesStyle: getAreaSeriesStyle(visData)
  });
};
exports.AreaSeriesComponent = AreaSeriesComponent;