"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePagination = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const usePagination = (visParams, rowCount) => {
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0,
    pageSize: visParams.perPage || 0
  });
  const onChangeItemsPerPage = (0, _react.useCallback)(pageSize => setPagination(pag => ({
    ...pag,
    pageSize,
    pageIndex: 0
  })), []);
  const onChangePage = (0, _react.useCallback)(pageIndex => setPagination(pag => ({
    ...pag,
    pageIndex
  })), []);
  (0, _react.useEffect)(() => {
    const pageSize = visParams.perPage || 0;
    const lastPageIndex = Math.ceil(rowCount / pageSize) - 1;
    /**
     * When the underlying data changes, there might be a case when actual pagination page
     * doesn't exist anymore - if the number of rows has decreased.
     * Set the last page as an actual.
     */
    setPagination(pag => ({
      pageIndex: pag.pageIndex > lastPageIndex ? lastPageIndex : pag.pageIndex,
      pageSize
    }));
  }, [visParams.perPage, rowCount]);
  const paginationMemoized = (0, _react.useMemo)(() => pagination.pageSize ? {
    ...pagination,
    onChangeItemsPerPage,
    onChangePage
  } : undefined, [onChangeItemsPerPage, onChangePage, pagination]);
  return paginationMemoized;
};
exports.usePagination = usePagination;