"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTableVisCell = void 0;
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createTableVisCell = (rows, formattedColumns, autoFitRowToContent) => ({
  rowIndex,
  columnId
}) => {
  var _rows$rowIndex;
  // incoming data might change and put the current page out of bounds - check whether row actually exists
  const rowValue = (_rows$rowIndex = rows[rowIndex]) === null || _rows$rowIndex === void 0 ? void 0 : _rows$rowIndex[columnId];
  const column = formattedColumns[columnId];
  const content = column === null || column === void 0 ? void 0 : column.formatter.convert(rowValue, 'html');
  const cellContent = /*#__PURE__*/_react.default.createElement("div", {
    /*
     * Justification for dangerouslySetInnerHTML:
     * The Data table visualization can "enrich" cell contents by applying a field formatter,
     * which we want to do if possible.
     */
    dangerouslySetInnerHTML: {
      __html: content
    } // eslint-disable-line react/no-danger
    ,
    "data-test-subj": "tbvChartCellContent",
    className: autoFitRowToContent ? '' : 'tbvChartCellContent'
  });
  return cellContent;
};
exports.createTableVisCell = createTableVisCell;