"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisDefaultEditorPlugin = void 0;
var _default_editor_controller = require("./default_editor_controller");
var _services = require("./services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class VisDefaultEditorPlugin {
  setup(core, {
    visualizations
  }) {
    (0, _services.setAnalytics)(core.analytics);
    (0, _services.setTheme)(core.theme);
    if (visualizations) {
      visualizations.visEditorsRegistry.registerDefault(_default_editor_controller.DefaultEditorController);
    }
  }
  start(core) {
    (0, _services.setCoreStart)(core);
  }
  stop() {}
}
exports.VisDefaultEditorPlugin = VisDefaultEditorPlugin;