"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEditorConfig = getEditorConfig;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * A hidden parameter can be hidden from the UI completely.
 */

/**
 * A fixed parameter has a fixed value for a specific field.
 * It can optionally also be hidden.
 */

/**
 * Numeric interval parameters must always be set in the editor to a multiple of
 * the specified base. It can optionally also be hidden.
 */

/**
 * Time interval parameters must always be set in the editor to a multiple of
 * the specified base. It can optionally also be hidden.
 */

function getEditorConfig(indexPattern, aggTypeName, fieldName) {
  const aggRestrictions = indexPattern.getAggregationRestrictions();
  if (!aggRestrictions || !aggTypeName || !fieldName) {
    return {};
  }

  // Exclude certain param options for terms:
  // otherBucket, missingBucket, orderBy, orderAgg
  if (aggTypeName === 'terms') {
    return {
      otherBucket: {
        hidden: true
      },
      missingBucket: {
        hidden: true
      }
    };
  }
  const fieldAgg = aggRestrictions[aggTypeName] && aggRestrictions[aggTypeName][fieldName];
  if (!fieldAgg) {
    return {};
  }

  // Set interval and base interval for histograms based on agg restrictions
  if (aggTypeName === 'histogram') {
    const interval = fieldAgg.interval;
    return interval ? {
      intervalBase: {
        fixedValue: interval
      },
      interval: {
        base: interval,
        help: _i18n.i18n.translate('visDefaultEditor.editorConfig.histogram.interval.helpText', {
          defaultMessage: 'Must be a multiple of configuration interval: {interval}',
          values: {
            interval
          }
        })
      }
    } : {};
  }

  // Set date histogram time zone based on agg restrictions
  if (aggTypeName === 'date_histogram') {
    // Interval is deprecated on date_histogram rollups, but may still be present
    // See https://github.com/elastic/kibana/pull/36310
    const interval = fieldAgg.calendar_interval || fieldAgg.fixed_interval;
    return {
      useNormalizedEsInterval: {
        fixedValue: false
      },
      interval: {
        default: interval,
        timeBase: interval,
        help: _i18n.i18n.translate('visDefaultEditor.editorConfig.dateHistogram.customInterval.helpText', {
          defaultMessage: 'Must be a multiple of configuration interval: {interval}',
          values: {
            interval
          }
        })
      }
    };
  }
  return {};
}