"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkedSearch = LinkedSearch;
exports.SidebarTitle = SidebarTitle;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/saved-search-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function LinkedSearch({
  savedSearch,
  eventEmitter
}) {
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  const {
    services: {
      application
    }
  } = (0, _public2.useKibana)();
  const closePopover = (0, _react.useCallback)(() => setShowPopover(false), []);
  const onClickButtonLink = (0, _react.useCallback)(() => setShowPopover(v => !v), []);
  const onClickUnlikFromSavedSearch = (0, _react.useCallback)(() => {
    setShowPopover(false);
    eventEmitter.emit('unlinkFromSavedSearch');
  }, [eventEmitter]);
  const onClickViewInDiscover = (0, _react.useCallback)(() => {
    application.navigateToApp('discover', {
      path: (0, _public.getSavedSearchUrl)(savedSearch.id)
    });
  }, [application, savedSearch.id]);
  const linkButtonAriaLabel = _i18n.i18n.translate('visDefaultEditor.sidebar.savedSearch.linkButtonAriaLabel', {
    defaultMessage: 'Link to Discover session. Click to learn more or break link.'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    className: "visEditorSidebar__titleContainer visEditorSidebar__linkedSearch",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "search"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    title: _i18n.i18n.translate('visDefaultEditor.sidebar.savedSearch.titleAriaLabel', {
      defaultMessage: 'Discover session: {title}',
      values: {
        title: savedSearch.title
      }
    })
  }, savedSearch.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: linkButtonAriaLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": linkButtonAriaLabel,
      "data-test-subj": "showUnlinkSavedSearchPopover",
      iconType: "link",
      onClick: onClickButtonLink
    })),
    isOpen: showPopover,
    closePopover: closePopover,
    panelPaddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.sidebar.savedSearch.popoverTitle",
    defaultMessage: "Linked to Discover session"
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: 260
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "viewSavedSearch",
    flush: "left",
    onClick: onClickViewInDiscover,
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.sidebar.savedSearch.goToDiscoverButtonText",
    defaultMessage: "View this session in Discover"
  }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.sidebar.savedSearch.popoverHelpText",
    defaultMessage: "Subsequent modifications to this Discover session are reflected in the visualization. To disable automatic updates, remove the link."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    "data-test-subj": "unlinkSavedSearch",
    fullWidth: true,
    onClick: onClickUnlikFromSavedSearch,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.sidebar.savedSearch.unlinkSavedSearchButtonText",
    defaultMessage: "Remove link to Discover session"
  }))))))));
}
function SidebarTitle({
  savedSearch,
  vis,
  isLinkedSearch,
  eventEmitter
}) {
  var _vis$data, _vis$data$indexPatter, _vis$data2, _vis$data2$indexPatte;
  return isLinkedSearch && savedSearch ? /*#__PURE__*/_react.default.createElement(LinkedSearch, {
    savedSearch: savedSearch,
    eventEmitter: eventEmitter
  }) : vis.type.options.showIndexSelection ? /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    className: "visEditorSidebar__titleContainer eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    title: _i18n.i18n.translate('visDefaultEditor.sidebar.indexPatternAriaLabel', {
      defaultMessage: 'Index pattern: {title}',
      values: {
        title: (_vis$data = vis.data) === null || _vis$data === void 0 ? void 0 : (_vis$data$indexPatter = _vis$data.indexPattern) === null || _vis$data$indexPatter === void 0 ? void 0 : _vis$data$indexPatter.getName()
      }
    })
  }, (_vis$data2 = vis.data) === null || _vis$data2 === void 0 ? void 0 : (_vis$data2$indexPatte = _vis$data2.indexPattern) === null || _vis$data2$indexPatte === void 0 ? void 0 : _vis$data2$indexPatte.getName())) : /*#__PURE__*/_react.default.createElement("div", {
    className: "visEditorSidebar__indexPatternPlaceholder"
  });
}