"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEditorAgg = DefaultEditorAgg;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _agg_params = require("./agg_params");
var _agg_group_state = require("./agg_group_state");
var _rows_or_columns = require("./controls/rows_or_columns");
var _radius_ratio_option = require("./controls/radius_ratio_option");
var _schemas = require("../schemas");
var _agg_params_helper = require("./agg_params_helper");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function DefaultEditorAgg({
  agg,
  aggIndex,
  aggIsTooLow,
  dragHandleProps,
  formIsTouched,
  groupName,
  isDisabled,
  isDraggable,
  isLastBucket,
  isRemovable,
  metricAggs,
  lastParentPipelineAggTitle,
  state,
  setAggParamValue,
  setStateParamValue,
  onAggTypeChange,
  onToggleEnableAgg,
  removeAgg,
  setAggsState,
  schemas,
  timeRange
}) {
  var _agg$type;
  const [isEditorOpen, setIsEditorOpen] = (0, _react.useState)(agg.brandNew);
  const [validState, setValidState] = (0, _react.useState)(true);
  const showDescription = !isEditorOpen && validState;
  const showError = !isEditorOpen && !validState;
  const aggName = (_agg$type = agg.type) === null || _agg$type === void 0 ? void 0 : _agg$type.name;
  const schemaTitle = (0, _schemas.getSchemaByName)(schemas, agg.schema).title;
  let disabledParams;
  let aggError;
  // When a Parent Pipeline agg is selected and this agg is the last bucket.
  const isLastBucketAgg = isLastBucket && lastParentPipelineAggTitle && agg.type;
  let SchemaComponent;
  if (agg.schema === 'split') {
    SchemaComponent = _rows_or_columns.RowsOrColumnsControl;
  }
  if (agg.schema === 'radius') {
    SchemaComponent = _radius_ratio_option.RadiusRatioOptionControl;
  }
  if (isLastBucketAgg) {
    if (['date_histogram', 'histogram'].includes(aggName)) {
      disabledParams = ['min_doc_count'];
    } else {
      aggError = _i18n.i18n.translate('visDefaultEditor.metrics.wrongLastBucketTypeErrorMessage', {
        defaultMessage: 'Last bucket aggregation must be "Date Histogram" or "Histogram" when using "{type}" metric aggregation.',
        values: {
          type: lastParentPipelineAggTitle
        },
        description: 'Date Histogram and Histogram should not be translated'
      });
    }
  }
  const [aggDescription, setAggDescription] = (0, _react.useState)((0, _agg_params_helper.buildAggDescription)(agg));

  // This useEffect is required to update the timeRange value and initiate rerender to keep labels up to date (Issue #57822).
  (0, _react.useEffect)(() => {
    if (timeRange && aggName === 'date_histogram') {
      agg.aggConfigs.setTimeRange(timeRange);
    }
    setAggDescription((0, _agg_params_helper.buildAggDescription)(agg));
  }, [agg, aggName, timeRange]);
  (0, _react.useEffect)(() => {
    if (isLastBucketAgg && ['date_histogram', 'histogram'].includes(aggName)) {
      setAggParamValue(agg.id, 'min_doc_count',
      // "histogram" agg has an editor for "min_doc_count" param, which accepts boolean
      // "date_histogram" agg doesn't have an editor for "min_doc_count" param, it should be set as a numeric value
      aggName === 'histogram' ? true : 0);
    }
  }, [aggName, isLastBucketAgg, agg.id, setAggParamValue]);
  const setTouched = (0, _react.useCallback)(touched => {
    setAggsState({
      type: _agg_group_state.AGGS_ACTION_KEYS.TOUCHED,
      payload: touched,
      aggId: agg.id
    });
  }, [agg.id, setAggsState]);
  const setValidity = (0, _react.useCallback)(isValid => {
    setAggsState({
      type: _agg_group_state.AGGS_ACTION_KEYS.VALID,
      payload: isValid,
      aggId: agg.id
    });
    setValidState(isValid);
  }, [agg.id, setAggsState]);
  const onToggle = (0, _react.useCallback)(isOpen => {
    setIsEditorOpen(isOpen);
    if (!isOpen) {
      setTouched(true);
    }
  }, [setTouched]);
  const renderAggButtons = () => {
    var _agg$type2, _agg$type2$title;
    const actionIcons = [];
    const aggTitle = (_agg$type2 = agg.type) === null || _agg$type2 === void 0 ? void 0 : (_agg$type2$title = _agg$type2.title) === null || _agg$type2$title === void 0 ? void 0 : _agg$type2$title.toLowerCase();
    if (showError) {
      actionIcons.push({
        id: 'hasErrors',
        color: 'danger',
        type: 'error',
        tooltip: _i18n.i18n.translate('visDefaultEditor.agg.errorsAriaLabel', {
          defaultMessage: '{schemaTitle} {aggTitle} aggregation has errors',
          values: {
            aggTitle,
            schemaTitle
          }
        }),
        dataTestSubj: 'hasErrorsAggregationIcon'
      });
    }
    if (agg.enabled && isRemovable) {
      actionIcons.push({
        id: 'disableAggregation',
        color: 'text',
        disabled: isDisabled,
        type: 'eye',
        onClick: () => onToggleEnableAgg(agg.id, false),
        tooltip: _i18n.i18n.translate('visDefaultEditor.agg.disableAggButtonTooltip', {
          defaultMessage: 'Disable {schemaTitle} {aggTitle} aggregation',
          values: {
            aggTitle,
            schemaTitle
          }
        }),
        dataTestSubj: 'toggleDisableAggregationBtn disable'
      });
    }
    if (!agg.enabled) {
      actionIcons.push({
        id: 'enableAggregation',
        color: 'text',
        type: 'eyeClosed',
        onClick: () => onToggleEnableAgg(agg.id, true),
        tooltip: _i18n.i18n.translate('visDefaultEditor.agg.enableAggButtonTooltip', {
          defaultMessage: 'Enable {schemaTitle} {aggTitle} aggregation',
          values: {
            aggTitle,
            schemaTitle
          }
        }),
        dataTestSubj: 'toggleDisableAggregationBtn enable'
      });
    }
    if (isDraggable) {
      actionIcons.push({
        id: 'dragHandle',
        color: 'text',
        type: 'grab',
        tooltip: _i18n.i18n.translate('visDefaultEditor.agg.modifyPriorityButtonTooltip', {
          defaultMessage: 'Modify priority of {schemaTitle} {aggTitle} by dragging',
          values: {
            aggTitle,
            schemaTitle
          }
        }),
        dataTestSubj: 'dragHandleBtn'
      });
    }
    if (isRemovable) {
      actionIcons.push({
        id: 'removeDimension',
        color: 'danger',
        type: 'cross',
        onClick: () => removeAgg(agg.id),
        tooltip: _i18n.i18n.translate('visDefaultEditor.agg.removeDimensionButtonTooltip', {
          defaultMessage: 'Remove {schemaTitle} {aggTitle} aggregation',
          values: {
            aggTitle,
            schemaTitle
          }
        }),
        dataTestSubj: 'removeDimensionBtn'
      });
    }
    return actionIcons.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, actionIcons.map(icon => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      key: icon.id,
      position: "bottom",
      content: icon.tooltip
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
      disabled: icon.disabled,
      iconType: icon.type,
      color: icon.color,
      onClick: icon.onClick,
      "aria-label": icon.tooltip,
      "data-test-subj": icon.dataTestSubj
    }, icon.id === 'dragHandle' ? dragHandleProps : {}))))) : null;
  };
  const buttonContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, schemaTitle || agg.schema, " ", showDescription && /*#__PURE__*/_react.default.createElement("span", null, aggDescription));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `visEditorAggAccordion${agg.id}`,
    initialIsOpen: isEditorOpen,
    buttonContent: buttonContent,
    buttonClassName: "eui-textTruncate",
    buttonContentClassName: "visEditorSidebar__aggGroupAccordionButtonContent eui-textTruncate",
    className: "visEditorSidebar__section visEditorSidebar__collapsible visEditorSidebar__collapsible--marginBottom",
    "aria-label": _i18n.i18n.translate('visDefaultEditor.agg.toggleEditorButtonAriaLabel', {
      defaultMessage: 'Toggle {schema} editor',
      values: {
        schema: schemaTitle || agg.schema
      }
    }),
    "data-test-subj": `visEditorAggAccordion${agg.id}`,
    extraAction: renderAggButtons(),
    onToggle: onToggle
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), SchemaComponent && /*#__PURE__*/_react.default.createElement(SchemaComponent, {
    agg: agg,
    editorStateParams: state.params,
    setAggParamValue: setAggParamValue,
    setStateParamValue: setStateParamValue
  }), /*#__PURE__*/_react.default.createElement(_agg_params.DefaultEditorAggParams, {
    agg: agg,
    aggError: aggError,
    aggIndex: aggIndex,
    aggIsTooLow: aggIsTooLow,
    disabledParams: disabledParams,
    formIsTouched: formIsTouched,
    groupName: groupName,
    indexPattern: agg.getIndexPattern(),
    metricAggs: metricAggs,
    state: state,
    setAggParamValue: setAggParamValue,
    onAggTypeChange: onAggTypeChange,
    setTouched: setTouched,
    setValidity: setValidity,
    schemas: schemas
  })));
}