"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRumErrorsProjection = getRumErrorsProjection;
exports.getRumPageExitTransactionsProjection = getRumPageExitTransactionsProjection;
exports.getRumPageLoadTransactionsProjection = getRumPageLoadTransactionsProjection;
var _common = require("@kbn/observability-plugin/common");
var _elasticsearch_fieldnames = require("../../../common/elasticsearch_fieldnames");
var _transaction_types = require("../../../common/transaction_types");
var _get_es_filter = require("./get_es_filter");
var _range_query = require("./range_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getRumPageLoadTransactionsProjection({
  setup,
  urlQuery,
  checkFetchStartFieldExists = true,
  start,
  end
}) {
  const {
    uiFilters
  } = setup;
  const bool = {
    filter: [...(0, _range_query.rangeQuery)(start, end), {
      term: {
        [_elasticsearch_fieldnames.TRANSACTION_TYPE]: _transaction_types.TRANSACTION_PAGE_LOAD
      }
    }, {
      terms: {
        [_elasticsearch_fieldnames.PROCESSOR_EVENT]: [_common.ProcessorEvent.transaction]
      }
    }, ...(checkFetchStartFieldExists ? [{
      // Adding this filter to cater for some inconsistent rum data
      // not available on aggregated transactions
      exists: {
        field: 'transaction.marks.navigationTiming.fetchStart'
      }
    }] : []), ...(urlQuery ? [{
      wildcard: {
        'url.full': `*${urlQuery}*`
      }
    }] : []), ...(0, _get_es_filter.getEsFilter)(uiFilters)],
    must_not: [...(0, _get_es_filter.getEsFilter)(uiFilters, true)]
  };
  return {
    body: {
      query: {
        bool
      }
    }
  };
}
function getRumPageExitTransactionsProjection({
  setup,
  urlQuery,
  start,
  end
}) {
  const {
    uiFilters
  } = setup;
  const bool = {
    filter: [...(0, _range_query.rangeQuery)(start, end), {
      term: {
        [_elasticsearch_fieldnames.TRANSACTION_TYPE]: _transaction_types.TRANSACTION_PAGE_EXIT
      }
    }, {
      terms: {
        [_elasticsearch_fieldnames.PROCESSOR_EVENT]: [_common.ProcessorEvent.transaction]
      }
    }, ...(urlQuery ? [{
      wildcard: {
        'url.full': `*${urlQuery}*`
      }
    }] : []), ...(0, _get_es_filter.getEsFilter)(uiFilters)],
    must_not: [...(0, _get_es_filter.getEsFilter)(uiFilters, true)]
  };
  return {
    body: {
      query: {
        bool
      }
    }
  };
}
function getRumErrorsProjection({
  setup,
  urlQuery,
  start,
  end
}) {
  return {
    body: {
      query: {
        bool: {
          filter: [...(0, _range_query.rangeQuery)(start, end), {
            term: {
              [_elasticsearch_fieldnames.AGENT_NAME]: 'rum-js'
            }
          }, {
            terms: {
              [_elasticsearch_fieldnames.PROCESSOR_EVENT]: [_common.ProcessorEvent.error]
            }
          }, ...(0, _get_es_filter.getEsFilter)(setup.uiFilters), ...(urlQuery ? [{
            wildcard: {
              'url.full': `*${urlQuery}*`
            }
          }] : [])],
          must_not: [...(0, _get_es_filter.getEsFilter)(setup.uiFilters, true)]
        }
      }
    }
  };
}