"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDateRangeRedirect = useDateRangeRedirect;
var _queryString = _interopRequireDefault(require("query-string"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/data-plugin/public");
var _use_kibana_services = require("./use_kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDateRangeRedirect() {
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const query = _queryString.default.parse(location.search);
  const {
    data,
    uiSettings
  } = (0, _use_kibana_services.useKibanaServices)();
  const timePickerTimeDefaults = uiSettings.get(_public.UI_SETTINGS.TIMEPICKER_TIME_DEFAULTS);
  const timePickerSharedState = data.query.timefilter.timefilter.getTime();
  const isDateRangeSet = 'rangeFrom' in query && 'rangeTo' in query;
  const redirect = () => {
    var _timePickerSharedStat, _timePickerSharedStat2;
    const nextQuery = {
      rangeFrom: (_timePickerSharedStat = timePickerSharedState.from) !== null && _timePickerSharedStat !== void 0 ? _timePickerSharedStat : timePickerTimeDefaults.from,
      rangeTo: (_timePickerSharedStat2 = timePickerSharedState.to) !== null && _timePickerSharedStat2 !== void 0 ? _timePickerSharedStat2 : timePickerTimeDefaults.to,
      ...query
    };
    history.replace({
      ...location,
      search: _queryString.default.stringify(nextQuery)
    });
  };
  return {
    isDateRangeSet,
    redirect
  };
}