"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreakpoints = useBreakpoints;
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useBreakpoints() {
  const screenSizes = {
    isXSmall: (0, _eui.useIsWithinMaxBreakpoint)('xs'),
    isSmall: (0, _eui.useIsWithinMaxBreakpoint)('s'),
    isMedium: (0, _eui.useIsWithinMaxBreakpoint)('m'),
    isLarge: (0, _eui.useIsWithinMaxBreakpoint)('l'),
    isXl: (0, _eui.useIsWithinMaxBreakpoint)('xl'),
    isXXL: (0, _eui.useIsWithinMaxBreakpoint)('xxl'),
    isXXXL: (0, _eui.useIsWithinMinBreakpoint)('xxxl')
  };
  return screenSizes;
}