"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usageCountersSearchParamsToKueryFilter = usageCountersSearchParamsToKueryFilter;
var _esQuery = require("@kbn/es-query");
var _saved_objects = require("../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function usageCountersSearchParamsToKueryFilter(params) {
  const {
    domainId,
    counterName,
    counterType,
    source,
    from,
    to
  } = params;
  const isFilters = filtersToKueryNodes({
    domainId,
    counterName,
    counterType,
    source
  });
  // add a date range filters
  if (from) {
    isFilters.push(_esQuery.nodeTypes.function.buildNode('range', `${_saved_objects.USAGE_COUNTERS_SAVED_OBJECT_TYPE}.updated_at`, 'gte', from));
  }
  if (to) {
    isFilters.push(_esQuery.nodeTypes.function.buildNode('range', `${_saved_objects.USAGE_COUNTERS_SAVED_OBJECT_TYPE}.updated_at`, 'lte', to));
  }
  return _esQuery.nodeTypes.function.buildNode('and', isFilters);
}
function filtersToKueryNodes(filters) {
  return Object.entries(filters).filter(([, attributeValue]) => typeof attributeValue === 'string' && attributeValue).map(([attributeName, attributeValue]) => _esQuery.nodeTypes.function.buildNode('is', `${_saved_objects.USAGE_COUNTERS_SAVED_OBJECT_TYPE}.attributes.${attributeName}`, attributeValue));
}