"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGetIndexStatusRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createGetIndexStatusRoute = libs => ({
  method: 'GET',
  path: _constants.API_URLS.INDEX_STATUS,
  validate: {
    query: _configSchema.schema.object({
      from: _configSchema.schema.maybe(_configSchema.schema.string()),
      to: _configSchema.schema.maybe(_configSchema.schema.string())
    })
  },
  handler: async ({
    uptimeEsClient,
    request,
    response
  }) => {
    const {
      from,
      to
    } = request.query;
    try {
      return await libs.requests.getIndexStatus({
        uptimeEsClient,
        range: {
          from,
          to
        }
      });
    } catch (e) {
      var _e$meta;
      if (((_e$meta = e.meta) === null || _e$meta === void 0 ? void 0 : _e$meta.statusCode) === 403) {
        return response.customError({
          statusCode: 403,
          body: {
            message: 'unauthorized: You do not have the required permissions to read uptime indices'
          }
        });
      }
      throw e;
    }
  }
});
exports.createGetIndexStatusRoute = createGetIndexStatusRoute;