"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mlJobsReducer = void 0;
var _reduxActions = require("redux-actions");
var _actions = require("../actions");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  mlJob: (0, _utils.asyncInitState)(),
  createJob: (0, _utils.asyncInitState)(),
  deleteJob: (0, _utils.asyncInitState)(),
  anomalies: (0, _utils.asyncInitState)(),
  mlCapabilities: (0, _utils.asyncInitState)()
};
const mlJobsReducer = exports.mlJobsReducer = (0, _reduxActions.handleActions)({
  ...(0, _utils.handleAsyncAction)('mlJob', _actions.getExistingMLJobAction),
  ...(0, _utils.handleAsyncAction)('mlCapabilities', _actions.getMLCapabilitiesAction),
  ...(0, _utils.handleAsyncAction)('createJob', _actions.createMLJobAction),
  ...(0, _utils.handleAsyncAction)('deleteJob', _actions.deleteMLJobAction),
  ...(0, _utils.handleAsyncAction)('anomalies', _actions.getAnomalyRecordsAction),
  ...{
    [String(_actions.resetMLState)]: state => ({
      ...state,
      mlJob: {
        loading: false,
        data: null,
        error: null
      },
      createJob: {
        data: null,
        error: null,
        loading: false
      },
      deleteJob: {
        data: null,
        error: null,
        loading: false
      }
    })
  }
}, initialState);