"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchPingHistogramEffect = fetchPingHistogramEffect;
exports.fetchPingsEffect = fetchPingsEffect;
var _effects = require("redux-saga/effects");
var _actions = require("../actions");
var _api = require("../api");
var _fetch_effect = require("./fetch_effect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* fetchPingsEffect() {
  yield (0, _effects.takeLatest)(String(_actions.getPings), (0, _fetch_effect.fetchEffectFactory)(_api.fetchPings, _actions.getPingsSuccess, _actions.getPingsFail));
}
function* fetchPingHistogramEffect() {
  yield (0, _effects.takeLatest)(String(_actions.getPingHistogram.get), (0, _fetch_effect.fetchEffectFactory)(_api.fetchPingHistogram, _actions.getPingHistogram.success, _actions.getPingHistogram.fail));
}