"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rootEffect = rootEffect;
var _effects = require("redux-saga/effects");
var _monitor = require("./monitor");
var _monitor_list = require("./monitor_list");
var _monitor_status = require("./monitor_status");
var _dynamic_settings = require("./dynamic_settings");
var _ping = require("./ping");
var _monitor_duration = require("./monitor_duration");
var _ml_anomaly = require("./ml_anomaly");
var _index_status = require("./index_status");
var _alerts = require("../alerts/alerts");
var _journey = require("./journey");
var _network_events = require("./network_events");
var _synthetic_journey_blocks = require("./synthetic_journey_blocks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* rootEffect() {
  yield (0, _effects.fork)(_monitor.fetchMonitorDetailsEffect);
  yield (0, _effects.fork)(_monitor_list.fetchMonitorListEffect);
  yield (0, _effects.fork)(_monitor_status.fetchMonitorStatusEffect);
  yield (0, _effects.fork)(_dynamic_settings.fetchDynamicSettingsEffect);
  yield (0, _effects.fork)(_dynamic_settings.setDynamicSettingsEffect);
  yield (0, _effects.fork)(_ping.fetchPingsEffect);
  yield (0, _effects.fork)(_ping.fetchPingHistogramEffect);
  yield (0, _effects.fork)(_ml_anomaly.fetchMLJobEffect);
  yield (0, _effects.fork)(_monitor_duration.fetchMonitorDurationEffect);
  yield (0, _effects.fork)(_index_status.fetchIndexStatusEffect);
  yield (0, _effects.fork)(_alerts.fetchAlertsEffect);
  yield (0, _effects.fork)(_journey.fetchJourneyStepsEffect);
  yield (0, _effects.fork)(_network_events.fetchNetworkEventsEffect);
  yield (0, _effects.fork)(_synthetic_journey_blocks.fetchScreenshotBlocks);
  yield (0, _effects.fork)(_synthetic_journey_blocks.generateBlockStatsOnPut);
  yield (0, _effects.fork)(_synthetic_journey_blocks.pruneBlockCache);
}