"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchJourneySteps = fetchJourneySteps;
exports.fetchJourneysFailedSteps = fetchJourneysFailedSteps;
exports.fetchLastSuccessfulCheck = fetchLastSuccessfulCheck;
exports.fetchScreenshotBlockSet = fetchScreenshotBlockSet;
exports.getJourneyScreenshot = getJourneyScreenshot;
var _utils = require("./utils");
var _ping = require("../../../../common/runtime_types/ping/ping");
var _synthetics = require("../../../../common/runtime_types/ping/synthetics");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchScreenshotBlockSet(params) {
  return _utils.apiService.post(_constants.API_URLS.JOURNEY_SCREENSHOT_BLOCKS, {
    hashes: params
  });
}
async function fetchJourneySteps(params) {
  return _utils.apiService.get(`/internal/uptime/journey/${params.checkGroup}`, {
    syntheticEventTypes: params.syntheticEventTypes
  }, _synthetics.SyntheticsJourneyApiResponseType);
}
async function fetchJourneysFailedSteps({
  checkGroups
}) {
  return _utils.apiService.get(_constants.API_URLS.JOURNEY_FAILED_STEPS, {
    checkGroups
  }, _synthetics.FailedStepsApiResponseType);
}
async function fetchLastSuccessfulCheck({
  monitorId,
  timestamp,
  stepIndex,
  location
}) {
  return await _utils.apiService.get(_constants.API_URLS.SYNTHETICS_SUCCESSFUL_CHECK, {
    monitorId,
    timestamp,
    stepIndex,
    location
  }, _ping.PingType);
}
async function getJourneyScreenshot(imgSrc) {
  try {
    var _response$headers$get;
    const imgRequest = new Request(imgSrc);
    const response = await fetch(imgRequest);
    if (response.status !== 200) {
      return null;
    }
    const contentType = response.headers.get('content-type');
    const stepName = response.headers.get('caption-name');
    const maxSteps = Number((_response$headers$get = response.headers.get('max-steps')) !== null && _response$headers$get !== void 0 ? _response$headers$get : 0);
    if ((contentType === null || contentType === void 0 ? void 0 : contentType.indexOf('application/json')) !== -1) {
      return {
        stepName,
        maxSteps,
        ref: await response.json()
      };
    } else {
      return {
        stepName,
        maxSteps,
        src: URL.createObjectURL(await response.blob())
      };
    }
  } catch (e) {
    return null;
  }
}