"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setDynamicSettings = exports.getDynamicSettings = void 0;
var _runtime_types = require("../../../../common/runtime_types");
var _utils = require("./utils");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDynamicSettings = async () => {
  return await _utils.apiService.get(_constants.API_URLS.DYNAMIC_SETTINGS, {
    version: _constants.INITIAL_REST_VERSION
  }, _runtime_types.DynamicSettingsCodec);
};
exports.getDynamicSettings = getDynamicSettings;
const setDynamicSettings = async ({
  settings
}) => {
  return await _utils.apiService.put(_constants.API_URLS.DYNAMIC_SETTINGS, settings, _runtime_types.DynamicSettingsSaveCodec, {
    version: _constants.INITIAL_REST_VERSION
  });
};
exports.setDynamicSettings = setDynamicSettings;