"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUrlParams = exports.useGetUrlParams = void 0;
var _react = require("react");
var _queryString = require("query-string");
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _helper = require("../lib/helper");
var _selectors = require("../state/selectors");
var _selected_filters = require("../state/actions/selected_filters");
var _use_selected_filters = require("./use_selected_filters");
var _parse_search = require("../lib/helper/parse_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetUrlParams = () => {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  return (0, _helper.getSupportedUrlParams)((0, _parse_search.getParsedParams)(search));
};
exports.useGetUrlParams = useGetUrlParams;
const getMapFromFilters = value => {
  try {
    return new Map(JSON.parse(value));
  } catch {
    return undefined;
  }
};
const useUrlParams = () => {
  const {
    pathname,
    search
  } = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const selectedFilters = (0, _reactRedux.useSelector)(_selectors.selectedFiltersSelector);
  const {
    filters
  } = useGetUrlParams();
  (0, _react.useEffect)(() => {
    if (selectedFilters === null) {
      const filterMap = getMapFromFilters(filters);
      if (filterMap) {
        dispatch((0, _selected_filters.setSelectedFilters)((0, _use_selected_filters.getFiltersFromMap)(filterMap)));
      }
    }
  }, [dispatch, filters, selectedFilters]);
  const updateUrlParams = (0, _react.useCallback)(updatedParams => {
    const currentParams = (0, _parse_search.getParsedParams)(search);
    const mergedParams = {
      ...currentParams,
      ...updatedParams
    };
    const updatedSearch = (0, _queryString.stringify)(
    // drop any parameters that have no value
    Object.keys(mergedParams).reduce((params, key) => {
      const value = mergedParams[key];
      if (value === undefined || value === '') {
        return params;
      }
      return {
        ...params,
        [key]: value
      };
    }, {}));

    // only update the URL if the search has actually changed
    if (search !== updatedSearch) {
      history.push({
        pathname,
        search: updatedSearch
      });
    }
    const filterMap = getMapFromFilters(mergedParams.filters);
    if (!filterMap) {
      dispatch((0, _selected_filters.setSelectedFilters)(null));
    } else {
      dispatch((0, _selected_filters.setSelectedFilters)((0, _use_selected_filters.getFiltersFromMap)(filterMap)));
    }
  }, [dispatch, history, pathname, search]);
  return [useGetUrlParams, updateUrlParams];
};
exports.useUrlParams = useUrlParams;