"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CodeBlockAccordion = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Utility for showing `EuiAccordions` with code blocks which we use frequently in synthetics to display
 * stack traces, long error messages, and synthetics journey code.
 */
const CodeBlockAccordion = ({
  buttonContent,
  children,
  id,
  language,
  overflowHeight,
  initialIsOpen = false
}) => {
  return children && id ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: id,
    buttonContent: buttonContent,
    initialIsOpen: initialIsOpen
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    overflowHeight: overflowHeight,
    language: language
  }, children)) : null;
};
exports.CodeBlockAccordion = CodeBlockAccordion;