"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CertificateExpirationForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CertificateExpirationForm = ({
  loading,
  onChange,
  formFields,
  fieldErrors,
  isDisabled
}) => {
  var _formFields$certExpir, _formFields$certAgeTh;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.certificationSectionTitle",
    defaultMessage: "Certificate Expiration"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.expirationThreshold",
      defaultMessage: "Expiration/Age Thresholds"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.certificateThresholdDescription",
      defaultMessage: "Change the threshold for displaying and alerting on certificate errors. Note: this will affect any configured alerts."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    describedByIds: ['errorState'],
    error: fieldErrors === null || fieldErrors === void 0 ? void 0 : fieldErrors.expirationThresholdError,
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.expirationThresholdDefaultValue",
      defaultMessage: "The default value is {defaultValue}",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _constants.DYNAMIC_SETTINGS_DEFAULTS.certExpirationThreshold)
      }
    }),
    isInvalid: !!(fieldErrors !== null && fieldErrors !== void 0 && fieldErrors.expirationThresholdError),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.errorStateLabel",
      defaultMessage: "Expiration threshold"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "aria-label": _translations.certificateFormTranslations.expirationInputAriaLabel,
    "data-test-subj": `expiration-threshold-input-${loading ? 'loading' : 'loaded'}`,
    fullWidth: true,
    disabled: isDisabled,
    isInvalid: !!(fieldErrors !== null && fieldErrors !== void 0 && fieldErrors.expirationThresholdError),
    isLoading: loading,
    value: (_formFields$certExpir = formFields === null || formFields === void 0 ? void 0 : formFields.certExpirationThreshold) !== null && _formFields$certExpir !== void 0 ? _formFields$certExpir : '',
    onChange: e => onChange({
      certExpirationThreshold: Number(e.target.value) || undefined
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.ageLimit.units.days",
    defaultMessage: "Days"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    describedByIds: ['warningState'],
    error: fieldErrors === null || fieldErrors === void 0 ? void 0 : fieldErrors.ageThresholdError,
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.ageThresholdDefaultValue",
      defaultMessage: "The default value is {defaultValue}",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, _constants.DYNAMIC_SETTINGS_DEFAULTS.certAgeThreshold)
      }
    }),
    isInvalid: !!(fieldErrors !== null && fieldErrors !== void 0 && fieldErrors.ageThresholdError),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.warningStateLabel",
      defaultMessage: "Age limit"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "aria-label": _translations.certificateFormTranslations.ageInputAriaLabel,
    "data-test-subj": `age-threshold-input-${loading ? 'loading' : 'loaded'}`,
    fullWidth: true,
    disabled: isDisabled,
    isInvalid: !!(fieldErrors !== null && fieldErrors !== void 0 && fieldErrors.ageThresholdError),
    isLoading: loading,
    value: (_formFields$certAgeTh = formFields === null || formFields === void 0 ? void 0 : formFields.certAgeThreshold) !== null && _formFields$certAgeTh !== void 0 ? _formFields$certAgeTh : '',
    onChange: ({
      target: {
        value
      }
    }) => onChange({
      certAgeThreshold: Number(value) || undefined
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.ageLimit.units.days",
    defaultMessage: "Days"
  })))))));
};
exports.CertificateExpirationForm = CertificateExpirationForm;