"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertDefaultsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _alerts = require("../../state/alerts/alerts");
var _add_connector_flyout = require("./add_connector_flyout");
var _hooks = require("../../hooks");
var _translations = require("./translations");
var _use_init_app = require("../../hooks/use_init_app");
var _default_email = require("./default_email");
var _alerts2 = require("../../state/api/alerts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorSpan = _styledComponents.default.span`
  .euiIcon {
    margin-right: 5px;
  }
  > img {
    width: 16px;
    height: 20px;
  }
`;
const AlertDefaultsForm = ({
  onChange,
  loading,
  formFields,
  fieldErrors,
  isDisabled
}) => {
  const {
    services: {
      triggersActionsUi: {
        actionTypeRegistry
      }
    }
  } = (0, _public.useKibana)();
  const {
    focusConnectorField
  } = (0, _hooks.useGetUrlParams)();
  const updateUrlParams = (0, _hooks.useUrlParams)()[1];
  const inputRef = (0, _react.useRef)(null);
  const {
    data: actionTypes
  } = (0, _public2.useFetcher)(() => (0, _alerts2.fetchActionTypes)(), []);
  (0, _use_init_app.useInitApp)();
  (0, _react.useEffect)(() => {
    if (focusConnectorField && inputRef.current && !loading) {
      inputRef.current.focus();
    }
  }, [focusConnectorField, inputRef, loading]);
  const {
    data = []
  } = (0, _reactRedux.useSelector)(_alerts.connectorsSelector);
  const [error, setError] = (0, _react.useState)(undefined);
  const onBlur = () => {
    if (inputRef.current) {
      const {
        value
      } = inputRef.current;
      setError(value.length === 0 ? undefined : `"${value}" is not a valid option`);
    }
    if (inputRef.current && !loading && focusConnectorField) {
      updateUrlParams({
        focusConnectorField: undefined
      });
    }
  };
  const onSearchChange = (value, hasMatchingOptions) => {
    setError(value.length === 0 || hasMatchingOptions ? undefined : `"${value}" is not a valid option`);
  };
  const options = (data !== null && data !== void 0 ? data : []).filter(action => (actionTypes !== null && actionTypes !== void 0 ? actionTypes : []).find(type => type.id === action.actionTypeId)).map(connectorAction => ({
    value: connectorAction.id,
    label: connectorAction.name,
    'data-test-subj': connectorAction.name
  }));
  const renderOption = option => {
    var _data$find;
    const {
      label,
      value
    } = option;
    const {
      actionTypeId: type
    } = (_data$find = data === null || data === void 0 ? void 0 : data.find(dt => dt.id === value)) !== null && _data$find !== void 0 ? _data$find : {};
    return /*#__PURE__*/_react.default.createElement(ConnectorSpan, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: actionTypeRegistry.get(type).iconClass
    }), /*#__PURE__*/_react.default.createElement("span", null, label));
  };
  const onOptionChange = selectedOptions => {
    onChange({
      defaultConnectors: selectedOptions.map(item => {
        const conOpt = data === null || data === void 0 ? void 0 : data.find(dt => dt.id === item.value);
        return conOpt.id;
      })
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.alertDefaults",
    defaultMessage: "Alert defaults"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.alertConnectors",
      defaultMessage: "Alert Connectors"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.defaultConnectors.description",
      defaultMessage: "Default connectors to be used to send an alert."
    })
  }, /*#__PURE__*/_react.default.createElement(RowWrapper, {
    describedByIds: ['defaultConnectors'],
    error: error,
    fullWidth: true,
    isInvalid: !!error,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.defaultConnectors",
      defaultMessage: "Default connectors"
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_add_connector_flyout.AddConnectorFlyout, {
      isDisabled: isDisabled,
      focusInput: (0, _react.useCallback)(() => {
        if (inputRef.current) {
          inputRef.current.focus();
        }
      }, [])
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _translations.alertFormI18n.inputPlaceHolder,
    options: options,
    selectedOptions: options.filter(opt => {
      var _formFields$defaultCo;
      return formFields === null || formFields === void 0 ? void 0 : (_formFields$defaultCo = formFields.defaultConnectors) === null || _formFields$defaultCo === void 0 ? void 0 : _formFields$defaultCo.includes(opt.value);
    }),
    inputRef: input => {
      inputRef.current = input;
    },
    onSearchChange: onSearchChange,
    onBlur: onBlur,
    isLoading: loading,
    isDisabled: isDisabled,
    onChange: onOptionChange,
    "data-test-subj": `default-connectors-input-${loading ? 'loading' : 'loaded'}`,
    renderOption: renderOption
  }))), /*#__PURE__*/_react.default.createElement(_default_email.DefaultEmail, {
    value: formFields === null || formFields === void 0 ? void 0 : formFields.defaultEmail,
    connectors: formFields === null || formFields === void 0 ? void 0 : formFields.defaultConnectors,
    onChange: onChange,
    isLoading: loading,
    isDisabled: isDisabled,
    errors: fieldErrors === null || fieldErrors === void 0 ? void 0 : fieldErrors.invalidEmail
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.AlertDefaultsForm = AlertDefaultsForm;
const RowWrapper = (0, _styledComponents.default)(_eui.EuiFormRow)`
  &&& > .euiFormRow__labelWrapper {
    align-items: baseline;
  }
`;