"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnabledAlerts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _contexts = require("../../../../contexts");
var _common = require("../../../../lib/alert_types/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkGroupList = (0, _styledComponents.default)(_eui.EuiListGroup)`
  &&& {
    a {
      padding-left: 0;
      padding-top: 0;
    }
  }
`;
const EnabledAlerts = ({
  monitorAlerts,
  loading
}) => {
  const {
    basePath
  } = (0, _react.useContext)(_contexts.UptimeSettingsContext);
  const listItems = [];
  (monitorAlerts !== null && monitorAlerts !== void 0 ? monitorAlerts : []).forEach((alert, ind) => {
    listItems.push({
      size: 's',
      label: alert.name,
      href: (0, _common.getUrlForAlert)(alert.id, basePath),
      'data-test-subj': 'uptimeMonitorListDrawerAlert' + ind
    });
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.uptime.monitorList.enabledAlerts.title', {
    defaultMessage: 'Enabled rules',
    description: 'Rules enabled for this monitor'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, listItems.length === 0 && !loading && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n.i18n.translate('xpack.uptime.monitorList.enabledAlerts.noAlert', {
      defaultMessage: 'No rules are enabled for this monitor.'
    })
  }), loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(LinkGroupList, {
    listItems: listItems,
    flush: true
  })));
};
exports.EnabledAlerts = EnabledAlerts;