"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DownNoExpressionSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _alert_expression_popover = require("../alert_expression_popover");
var labels = _interopRequireWildcard(require("../translations"));
var _alert_field_number = require("../alert_field_number");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DownNoExpressionSelect = ({
  defaultNumTimes,
  hasFilters,
  isEnabled,
  setRuleParams
}) => {
  const [numTimes, setNumTimes] = (0, _react.useState)(defaultNumTimes !== null && defaultNumTimes !== void 0 ? defaultNumTimes : 5);
  (0, _react.useEffect)(() => {
    setRuleParams('numTimes', numTimes);
  }, [numTimes, setRuleParams]);
  return /*#__PURE__*/_react.default.createElement(_alert_expression_popover.AlertExpressionPopover, {
    "aria-label": labels.OPEN_THE_POPOVER_DOWN_COUNT,
    content: /*#__PURE__*/_react.default.createElement(_alert_field_number.AlertFieldNumber, {
      "aria-label": labels.ENTER_NUMBER_OF_DOWN_COUNTS,
      "data-test-subj": "xpack.synthetics.alerts.monitorStatus.numTimesField",
      disabled: false,
      fieldValue: numTimes,
      setFieldValue: setNumTimes
    }),
    "data-test-subj": "xpack.synthetics.alerts.monitorStatus.numTimesExpression",
    description: hasFilters ? labels.MATCHING_MONITORS_DOWN : labels.ANY_MONITOR_DOWN,
    id: "ping-count",
    isEnabled: isEnabled,
    value: `${numTimes} times`
  });
};
exports.DownNoExpressionSelect = DownNoExpressionSelect;